import React from 'react';
import {Card, Label} from '@yandex-data-ui/common';
import {observer} from 'mobx-react';

import {AllocationZoneStore} from '../../../stores/AllocationZoneStore';
import {FeaturesView} from './FeaturesView';
import {SessionsList} from './SessionsList';
import {SessionsChart} from './SessionsChart';

interface OverviewProps {
    store: AllocationZoneStore;
}

export const Overview: React.FunctionComponent<OverviewProps> = observer((props) => {
    const {features, pipeline} = props.store;

    return (
        <div
            style={{
                padding: '30px',
                display: 'grid',
                gridTemplateColumns: 'calc(50% - 15px) calc(50% - 15px)',
                gap: 30,
            }}
        >
            <Card>
                {props.store.detailsLoading && props.store.sessions.length === 0 ? (
                    'Loading'
                ) : props.store.detailsError ? (
                    <Label theme={'danger'}>Request failed</Label>
                ) : props.store.sessions.length === 0 ? (
                    'No data'
                ) : (
                    <>
                        <SessionsChart sessions={props.store.sessions.slice()} />
                        <SessionsList sessions={props.store.sessions.slice()} />
                    </>
                )}
            </Card>
            {features && pipeline && (
                <>
                    <Card>
                        {props.store.pipeline && props.store.features && (
                            <FeaturesView
                                allocationZone={props.store.id}
                                pipeline={props.store.pipeline}
                                features={props.store.features}
                            />
                        )}
                    </Card>
                </>
            )}
        </div>
    );
});
