import React from 'react';
import {Session} from '../../../stores/AllocationZoneStore';
import {CircleIcon} from '../../../components/icons/CircleIcon';
import {format, formatDuration, intervalToDuration} from 'date-fns';
import {Label, LabelProps} from '@yandex-data-ui/common';
import {ExternalLink} from '../../../components/ExternalLink/ExternalLink';

import colors from '../../../design/colors.module.css';
import styles from '../AllocationZone.module.css';

const Styles = {
    reallocation: 'info',
    redeployment: 'success',
    cooldown: 'unknown',
} as {[key: string]: LabelProps['theme']};

export const SessionsList: React.FunctionComponent<{sessions: Session[]}> = (props) => {
    return (
        <>
            {props.sessions
                .slice()
                .reverse()
                .map((item, index, array) => (
                    <div
                        style={{
                            display: 'flex',
                            padding: '10px',
                            borderTop: '1px solid var(--yc-color-line-generic)',
                            opacity: item.session.is_in_progress ? 1 : 0.7,
                        }}
                    >
                        <div style={{flexGrow: 1}}>
                            <div style={{display: 'flex', alignItems: 'center'}}>
                                {item.session.is_in_progress && (
                                    <CircleIcon
                                        size={'xs'}
                                        color={'var(--yc-color-infographics-danger-heavy)'}
                                        style={{marginRight: '8px'}}
                                    />
                                )}{' '}
                                {item.type}
                            </div>
                            <div style={{fontSize: '10px', color: colors.textSecondary}}>
                                Start time: {format(item.session.start_ts * 1000, 'HH:mm')}{' '}
                                <span>
                                    Taskgroups:{' '}
                                    {item.session.taskgroups_ids.map((linkItem, i, arr) => (
                                        <ExternalLink className={styles.LinksItem} href={linkItem}>{i + 1}</ExternalLink>
                                    ))}
                                </span>{' '}
                                <span>
                                    Snapshots:{' '}
                                    {item.session.snapshot_ids.map((linkItem, i, arr) => (
                                        <ExternalLink className={styles.LinksItem} href={linkItem}>
                                            {i + 1}
                                        </ExternalLink>
                                    ))}
                                </span>
                            </div>
                        </div>
                        <Label theme={Styles[item.type]}>
                            {formatDuration(
                                intervalToDuration({
                                    start: item.session.start_ts * 1000,
                                    end: item.session.end_ts * 1000,
                                })
                            )}
                        </Label>
                    </div>
                ))}
        </>
    );
};
