import React from 'react';
import {Label, List} from '@yandex-data-ui/common';

import {Pipeline} from '../../../stores/AllocationZoneStore';
import {NTentaclesApi} from '../../../api/tentacles/stubs/tentacles';

import styles from '../Sessions.module.css';

interface PipelineFiltersViewProps {
    pipeline: Pipeline;
    className?: string;
    setFilter: (filter?: NTentaclesApi.EPodFilter) => void;
    filter?: NTentaclesApi.EPodFilter;
}

export const PipelineFiltersView: React.FunctionComponent<PipelineFiltersViewProps> = (props) => {
    const [activeIndex, setActiveIndex] = React.useState<number | undefined>(undefined);
    const ITEMS = React.useMemo(
        () => [
            {
                title: 'Walle',
                group: true,
                disabled: true,
            },
            {
                title: 'decomissioned',
                total: props.pipeline.walle.excluded_decommissioned_nodes_count,
                filter: NTentaclesApi.EPodFilter.EXCLUDED_DECOMMISSIONED_NODES,
            },
            {
                title: 'probation',
                total: props.pipeline.walle.excluded_probation_or_free_nodes_count,
                filter: NTentaclesApi.EPodFilter.EXCLUDED_PROBATION_OR_FREE_NODES,
            },
            {
                title: 'Allocator',
                group: true,
                disabled: true,
                total: props.pipeline.allocator.total_pods_count,
            },
            {
                title: 'scheduling errors',
                total: props.pipeline.allocator.pods_scheduling_errors,
                filter: NTentaclesApi.EPodFilter.PODS_SCHEDULING_ERRORS,
            },
            {
                title: 'HQ',
                group: true,
                disabled: true,
                total: props.pipeline.hq.total_pods,
            },
            {
                title: 'no available filter',
                disabled: true,
            },
            {
                title: 'Juggler',
                group: true,
                disabled: true,
                total: props.pipeline.juggler.total_pods,
            },
            {
                title: 'not visible',
                total: props.pipeline.juggler.excluded_not_visible,
                filter: NTentaclesApi.EPodFilter.EXCLUDED_NOT_VISIBLE,
            },
            {
                title: 'not present',
                total: props.pipeline.juggler.excluded_not_present,
                filter: NTentaclesApi.EPodFilter.EXCLUDED_NOT_PRESENT,
            },
            {
                title: 'Availability',
                group: true,
                disabled: true,
                total: props.pipeline.availability.total_count,
            },
            {
                title: 'not reachable',
                total: props.pipeline.availability.excluded_not_reachable,
                filter: NTentaclesApi.EPodFilter.EXCLUDED_NOT_REACHABLE,
            },
            {
                title: 'Redeployment',
                group: true,
                disabled: true,
                total: props.pipeline.redeployment.total_count,
            },
            {
                title: 'no available filter',
                disabled: true,
            },
        ],
        [props.pipeline]
    );

    React.useEffect(() => {
        if (props.filter === undefined) {
            setActiveIndex(undefined);
            return;
        }

        const selected = ITEMS.findIndex((item) => item.filter === props.filter);
        setActiveIndex(selected);
    }, [props.filter, setActiveIndex, ITEMS]);

    return (
        <List
            // ref={this.firstListRef}
            className={props.className}
            virtualized={false}
            items={ITEMS}
            onItemClick={(item, index) => {
                setActiveIndex(index);
                props.setFilter(item.filter);
            }}
            renderItem={(item) => {
                return (
                    <span
                        style={{
                            lineHeight: '28px',
                            paddingLeft: 14,
                            display: 'flex',
                            width: '100%',
                            paddingRight: 14,
                            alignItems: 'center',
                        }}
                    >
                        <span style={{flexGrow: 1}}>
                            {item.group ? (
                                <strong>
                                    {item.title}
                                    {item.total !== undefined && <span> ({item.total})</span>}
                                </strong>
                            ) : (
                                item.title
                            )}
                        </span>
                        {item.total !== undefined && !item.group && (
                            <Label className={styles.LabelXXS} theme={'normal'} style={'rounded'}>
                                {item.total}
                            </Label>
                        )}
                    </span>
                );
            }}
            activeItemIndex={activeIndex}
            // disabled={disabled}
            filterable={false}
        />
    );
};
