import React from 'react';
import {Dialog} from '@yandex-data-ui/common';
import {NTentaclesApi} from '../../api/tentacles/stubs/tentacles';
import {observer} from 'mobx-react';
import {deleteIncident} from '../../api/tentacles/deleteIncident';

interface CreateIncidentProps {
    onClose: () => void;
    onDelete: () => void;
    id: string;
}

export const DeleteIncidentModal: React.FunctionComponent<CreateIncidentProps> = observer((props) => {
    const onSubmit = React.useCallback(() => {
        deleteIncident({id: props.id}).then(props.onDelete);
    }, [props.id, props.onDelete]);

    return (
        <Dialog
            visible={true}
            onClose={props.onClose}
            hasButtonClose={false}
            autoclosable={false}
        >
            <Dialog.Body>
                <h3>Delete Incident</h3>
                <div>Are you sure you want to delete incident with id {props.id}?</div>
            </Dialog.Body>
            <Dialog.Footer
                preset='default'
                onClickButtonCancel={props.onClose}
                onClickButtonApply={onSubmit}
                textButtonApply='Delete'
                textButtonCancel='Cancel'
                listenKeyEnter
                renderButtons={(buttonApply, buttonCancel) => (
                    <>
                        {buttonCancel}
                        {buttonApply}
                    </>
                )}
            />
        </Dialog>
    );
});
