import React, {useCallback} from 'react';
import {observer} from 'mobx-react';
import {Collapse} from '@yandex-data-ui/common';
import {Panel} from '../../components/Panel/Panel';

import {OverviewSLOStore} from '../../stores/SLOStore';
import {SLOZone} from './SLOZone';

import styles from './SLO.module.css';
import {usePolling} from '../../hooks/usePolling';

interface SLOProps {
    store: OverviewSLOStore;
}

const SLO: React.FunctionComponent<SLOProps> = observer(({store}) => {
    const overview = store.read();
    const load = useCallback(() => store.load(), [store]);
    usePolling(load);

    return (
        <Panel>
            <div className={styles.section}>
                <Collapse title={'Gencfg'} dafaultIsExpand={true}>
                    <div className={styles.grid}>
                        {overview.gencfg.map((item) => (
                            <SLOZone key={item.zoneId} overview={item} />
                        ))}
                    </div>
                </Collapse>
            </div>
            <div className={styles.section}>
                <Collapse title={'YP.Lite reallocation disabled'} dafaultIsExpand={true}>
                    <div className={styles.grid}>
                        {overview.ypRealocationDisabled.map((item) => (
                            <SLOZone key={item.zoneId} overview={item} />
                        ))}
                    </div>
                </Collapse>
            </div>
            <div className={styles.section}>
                <Collapse title={'YP.Lite reallocation enabled'} dafaultIsExpand={true}>
                    <div className={styles.grid}>
                        {overview.ypRealocationEnabled.map((item) => (
                            <SLOZone key={item.zoneId} overview={item} />
                        ))}
                    </div>
                </Collapse>
            </div>
        </Panel>
    );
});

export default SLO;
