import React, {Suspense} from 'react';
import {OverviewSLOStore} from '../../stores/SLOStore';
import {useDoctitle} from '../../hooks/useDoctitle';
import {ContainerErrorFallback} from '../../components/ErrorFallback/ContainerErrorFallback';
import {SuspenseFallback} from '../../components/SuspenseFallback/SuspenseFallback';
import {ErrorBoundary} from 'react-error-boundary';

const SLO = React.lazy(() => import('./SLO'));

export const SLOContainer = () => {
    useDoctitle('SLO');
    const [store, setStore] = React.useState(new OverviewSLOStore());
    const resetStore = React.useCallback(() => {
        setStore(new OverviewSLOStore());
    }, [setStore]);

    return (
        <ErrorBoundary fallbackRender={ContainerErrorFallback} onReset={resetStore}>
            <Suspense fallback={<SuspenseFallback />}>
                <SLO store={store} />
            </Suspense>
        </ErrorBoundary>
    );
};
