import React from 'react';
import {Card, Label} from '@yandex-data-ui/common';
import {Link} from 'react-router-dom';
import classNames from 'classnames';

import {NTentaclesApi} from '../../api/tentacles/stubs/tentacles';
import {ZoneOverview} from '../../stores/SLOStore';
import routes from '../../routes';

import {TITLE} from './constants';
import {SLOZoneFeature} from './SLOZoneFeature';
import styles from './SLOZone.module.css';

interface AllocationZoneOverviewProps {
    overview: ZoneOverview;
}

export type AllowedFeatures =
    | 'dataFreshness'
    | 'availability'
    | 'redeploy'
    | 'reallocation'
    | 'unusedNodes'
    | 'schedulingErrors';

export const SLOZone: React.FunctionComponent<AllocationZoneOverviewProps> = ({overview}) => {
    const {zoneId} = overview;
    const allowedFeatures = React.useMemo<AllowedFeatures[]>(
        () => ['dataFreshness', 'availability', 'redeploy', 'reallocation', 'unusedNodes', 'schedulingErrors'],
        []
    );

    const isGood = allowedFeatures.every((feature) => overview[feature].status !== NTentaclesApi.EFeatureStatus.BROKEN);

    return (
        <Card className={styles.card}>
            <div className={styles.header}>
                <Link to={`${routes.zoneDetails}?name=${overview.zoneId}`} className={classNames('link', styles.title)}>
                    {TITLE[zoneId] || zoneId}
                </Link>
                <div>
                    {isGood ? (
                        <Label theme={'success'} size={'s'}>
                            OK
                        </Label>
                    ) : (
                        <Label theme={'danger'} size={'s'}>
                            BROKEN
                        </Label>
                    )}
                </div>
            </div>
            <br />
            <div className={styles.features}>
                {allowedFeatures.map((item) => (
                    <SLOZoneFeature featureName={item} overview={overview} />
                ))}
            </div>
        </Card>
    );
};
