import {useHistory, useLocation} from 'react-router-dom';
import React from 'react';

export function useSearchParam(name: string): [string | undefined, (value: string | undefined) => void] {
    const {search} = useLocation();
    const history = useHistory();

    const [value, setValue] = React.useState<string | undefined>(new URLSearchParams(search).get(name) || undefined);

    React.useEffect(() => {
        const searchParams = new URLSearchParams(search);
        const searchValue = searchParams.get(name) || undefined;

        setValue(searchValue);
    }, [name, search, setValue]);

    React.useEffect(() => {
        const searchParams = new URLSearchParams(history.location.search);
        const prevValue = searchParams.get(name) || undefined;

        if (value === prevValue) {
            return;
        }

        value === undefined ? searchParams.delete(name) : searchParams.set(name, value);
        history.push({search: `?${searchParams.toString()}`});
    }, [history, value, name]);

    return [value, setValue];
}
