import React from 'react';
import {of} from 'rxjs';
import {delay, mergeMap, repeat} from 'rxjs/operators';

interface Store {
    load: () => PromiseLike<void>;
}

export function useStorePolling(store?: Store) {
    React.useEffect(() => {
        if (!store) {
            return;
        }
        const polling = of({})
            .pipe(
                mergeMap(() => store.load()),
                // tap(({items}) => {
                //     errorsCounter = 0;
                //     this.setState({loading: false, outdated: false, items});
                // }),
                // catchError((err) => {
                //     throwError(err);
                //     return of({});
                // }),
                // catchError(() => {
                //     errorsCounter++;
                //     if (errorsCounter >= 3) {
                //         polling.unsubscribe();
                //         this.setState({outdated: true, loading: false});
                //     }
                //     return of({});
                // }),
                delay(5000),
                repeat()
            )
            .subscribe();

        return () => {
            polling.unsubscribe();
        };
    }, [store]);
}
