import React from 'react';
import ReactDOM from 'react-dom';
import {BrowserRouter as Router} from 'react-router-dom';

import {autorun, configure} from 'mobx';

import App from './containers/App/App';
import {UserStore} from './stores/UserStore';
import {UserContext} from './context/UserContex';

import errorBooster from './services/ErrorBooster';

import './index.css';
import {IncidentFiltersProvider} from './context/IncidentFiltersContext';
import {IncidentFiltersStore} from './stores/IncidentFiltersStore';

configure({
    enforceActions: 'always',
    computedRequiresReaction: true,
    reactionRequiresObservable: true,
    observableRequiresReaction: true,
    disableErrorBoundaries: true,
});

const userStore = new UserStore();

errorBooster.init();

autorun(() => {
    const useruid = userStore.userinfo?.current.yandexuid || 'anonymous';
    const username = userStore.userinfo?.current.login || 'anonymous';
    errorBooster.updateAdditional({
        useruid,
        username,
    });
});

ReactDOM.render(
    <React.StrictMode>
        <IncidentFiltersProvider value={new IncidentFiltersStore()}>
            <UserContext.Provider value={userStore}>
                <Router>
                    <App />
                </Router>
            </UserContext.Provider>
        </IncidentFiltersProvider>
    </React.StrictMode>,
    document.getElementById('root')
);
