import '@yandex-int/error-counter/dist/interfaceWithoutRum';

import '@yandex-int/error-counter/dist/implementation';
import '@yandex-int/error-counter/dist/filters';
import '@yandex-int/error-counter/dist/sendWithoutRum';
import '@yandex-int/error-counter/dist/logAjaxError';
import '@yandex-int/error-counter/dist/logError';

const ENVIRONMENTS: Record<string, Ya.Rum.LogEnvironment> = {
    'tentacles.yandex-team.ru': 'production',
    'tentacles-testing.yandex-team.ru': 'testing',
    'localhost.yandex-team.ru': 'development',
};

class ErrorBooster {
    public init() {
        const env = ENVIRONMENTS[window.location.hostname] || 'development';

        if (env === 'development') {
            return;
        }

        Ya.Rum.initErrors({
            project: 'tentacles-webapp',
            env,
            limits: {
                client: -1,
                uncaught: -1,
                script: -1,
                external: -1,
            },
            platform: 'desktop',
            version: process.env.REACT_APP_VERSION as string,
            unhandledRejection: true,
        });
    }

    updateAdditional(additional: Record<string, string>) {
        Ya.Rum.updateAdditional(additional);
    }
}

export default new ErrorBooster();
