import {makeAutoObservable, runInAction} from 'mobx';
import {NTentaclesApi} from '../api/tentacles/stubs/tentacles';
import {fetchIncidentFilters} from '../api/tentacles/fetchIncidentFilters';

export class IncidentFiltersStore {
    allocation_zones: string[] = [];
    assignees: string[] = [];
    slo_types: NTentaclesApi.ESloType[] = [];

    constructor() {
        makeAutoObservable(this);
        this.load();
    }

    async load() {
        const response = await fetchIncidentFilters({});
        const result = NTentaclesApi.TListIncidentFiltersResult.create(response.result!);
        const {allocation_zones, assignees, slo_types} = NTentaclesApi.TIncidentFiltersList.create(
            result.filters_list!
        );
        runInAction(() => {
            this.allocation_zones = allocation_zones;
            this.slo_types = slo_types;
            this.assignees = assignees;
        });
    }
}
