import {makeAutoObservable} from 'mobx';
import {fetchIncidents} from '../api/tentacles/fetchIncidents';
import {NTentaclesApi} from '../api/tentacles/stubs/tentacles';

export class IncidentsStore {
    incidents: NTentaclesApi.TIncident[] = [];
    sloMinutes: number = 0;
    filters: NTentaclesApi.ITIncidentFilter = {};

    constructor(from: number, to: number) {
        this.updateFilter({
            started_after_ts: from,
            ended_before_ts: to,
        });

        makeAutoObservable(this);
    }

    updateFilter(filter: NTentaclesApi.ITIncidentFilter) {
        this.filters = {
            ...this.filters,
            ...filter,
            started_after_ts: filter.hasOwnProperty('started_after_ts')
                ? filter.started_after_ts
                    ? Math.floor(filter.started_after_ts / 1000)
                    : undefined
                : this.filters.started_after_ts,
            ended_before_ts: filter.hasOwnProperty('ended_before_ts')
                ? filter.ended_before_ts
                    ? Math.floor(filter.ended_before_ts / 1000)
                    : undefined
                : this.filters.ended_before_ts,
        };
    }

    async load() {
        const response = await fetchIncidents({
            filter: this.filters,
        });

        const result = NTentaclesApi.TReadIncidentsResult.create(response.result!);
        this.incidents = result.incidents.map(NTentaclesApi.TIncident.create);
        this.sloMinutes = this.incidents.reduce((acc, item) => {
            return acc + item.minutes_out_of_slo;
        }, 0);
    }
}
