import {User as UserInfo} from '@yandex-data-ui/cloud-components/build/components/UserMenu/types';
import {makeAutoObservable} from 'mobx';
import Cookie from 'js-cookie';
import {fetchAccounts} from '../api/passport/fetchAccounts';

const yandexuid = Cookie.get('yandexuid')!;
const login = Cookie.get('yandex_login');

export class UserStore {
    userinfo?: {
        current: UserInfo;
        accounts: UserInfo[];
    };

    constructor() {
        makeAutoObservable(this);
        this.initialize();
        this.load();
    }

    protected initialize() {
        if (login) {
            const user = {
                login,
                yandexuid,
                avatarHost: 'https://center.yandex-team.ru',
                avatarId: login,
                uid: yandexuid,
                email: login + '@yandex-team.ru',
            };

            this.userinfo = {
                current: user,
                accounts: [user],
            };
        }
    }

    protected async load() {
        const accountsResponse = await fetchAccounts();

        if (!accountsResponse) {
            return;
        }

        const accounts = accountsResponse.accounts.map((item) => ({
            yandexuid,
            uid: item.uid,
            login: item.login,
            displayName: item.displayName.name,
            avatarId: item.displayName.default_avatar,
            email: item.defaultEmail,
            avatarHost: 'https://center.yandex-team.ru',
        }));

        const user = accounts.find((item) => item.uid === accountsResponse.default_uid)!;

        this.userinfo = {current: user, accounts};
    }
}
