"""
Script used for uploading eventlogs to YT tables
Example cmd:
    ./eventlog_uploader
    --yt-proxy banach.yt.yandex.net
    --yt-token my_lovely_token
    --evlogfolder //home/eventlogdata/{tier}
    --evlogdump %(BSCONFIG_IDIR)s/evlogdump
    --instance %(BSCONFIG_IHOST)s\:%(BSCONFIG_IPORT)s
    --log %(logs_dir)scurrent-eventlog-mmeta-%(BSCONFIG_IPORT)s
    // optional args:
    --period 300
    --sleep 3600
    --chance 0.03
    --days 4
"""

import eventlog_uploader_api as eu

import logging
import random
import time

logging.basicConfig(format="%(asctime)s:%(levelname)s:%(name)s:%(message)s", level=logging.DEBUG)


def main():
    logging.info("Start uploader")
    pars = eu.get_parser()
    parsed_args = pars.parse_args()

    if parsed_args.skip_instance is not None and parsed_args.instance.find(parsed_args.skip_instance) != -1:
        logging.info('Skipping launch: instance {} matches mask {}'.format(parsed_args.instance, parsed_args.skip_instance))
        return

    # make sure we never upload overlapping logs
    assert (parsed_args.sleep > parsed_args.period + 4 * 60)

    uploader = eu.Uploader(parsed_args)
    while True:
        roll = random.random()
        if roll < parsed_args.chance:
            logging.info("Rolled {}. Trying to upload something".format(roll))
            uploader.upload()
        else:
            logging.info("Rolled {}. Uploading nothing".format(roll))
        logging.info("Sleeping for {}".format(parsed_args.sleep))
        time.sleep(parsed_args.sleep)
