#include <infra/service_controller/libs/daemon/main.h>
#include <infra/service_controller/libs/print_diff/main.h>

#include <infra/libs/logger/log_printer.h>
#include <infra/libs/sensors/sensor_registry.h>

#include <library/cpp/getopt/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char* argv[]) {
    NInfra::SetSensorRegistryCommonGroup({"service_controller"});

    TModChooser modChooser;

    modChooser.AddMode(
        "run",
        NInfra::NServiceController::RunDaemon,
        "Run ServiceController daemon."
    );

    modChooser.AddMode(
        "print_log",
        NInfra::PrintEventLog,
        "Print ServiceController log."
    );

    modChooser.AddMode(
        "print_diff",
        NInfra::NServiceController::RunPrintDiff,
        "Print insert/remove diff of each sync cycle in JSON format."
    );

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return -1;
    }

    return 0;
}
