#include "main.h"

#include <infra/service_controller/libs/config/config.pb.h>
#include <infra/service_controller/libs/controller/controller.h>

#include <infra/libs/controller/daemon/main.h>

namespace NInfra::NServiceController {

int RunDaemon(int argc, const char* argv[]) {
    const TConfig config = NProtoConfig::GetOpt<TConfig>(argc, argv, "/proto_config/config.json");
    const NUpdatableProtoConfig::TConfigHolderConfig& updatableConfigOpts = config.GetController().GetUpdatableConfigOptions();

    NUpdatableProtoConfig::TConfigHolderPtr<TConfig> configHolder = NUpdatableProtoConfig::CreateConfigHolder(config, updatableConfigOpts);

    const size_t numberOfShards = config.GetShardsConfig().GetNumberOfShards();
    const NInfra::NLeadingInvader::TConfig livenessLeadingInvaderConfig = config.GetShardsConfig().GetLivenessLeadingInvader();
    bool managedByMaster = config.GetShardsConfig().GetManagedByMaster();
    const TString ensureShardMasterIsAliveTimeout = config.GetShardsConfig().GetEnsureShardMasterLivenessTimeout();
    const TString masterLeadingInvaderPath = config.GetShardsConfig().GetMasterLeadingInvaderPath();

    NInfra::NController::TSharding shardsFactory(
        config.GetController().GetLeadingInvader(),
        livenessLeadingInvaderConfig,
        numberOfShards,
        managedByMaster,
        ensureShardMasterIsAliveTimeout,
        masterLeadingInvaderPath
    );

    TVector<NController::TSingleClusterObjectManagersFactoryPtr> objectFactories;
    objectFactories.reserve(numberOfShards);
    for (size_t i = 0; i < numberOfShards; ++i) {
        objectFactories.emplace_back(new TEndpointSetManagerFactory(configHolder->Accessor<TEndpointSetManagerFactoryConfig>("EndpointSetManagerFactory"), shardsFactory.GetShard(i)));
    }

    return NController::RunDaemon<NController::TService>(
        configHolder->Accessor<NController::TControllerConfig>("Controller"),
        std::move(objectFactories)
    );
}

} // namespace NInfra::NServiceController
