#include "endpoint.h"

namespace NInfra::NServiceController {

void TEndpointData::Sync(const TEndpointData& e) {
    if (e.IsSyncedToYP()) {
        EndpointId_ = e.EndpointId_;
    }

    if (!e.PodId_.empty()) {
        PodId_ = e.PodId_;
    }
}

TEndpoint::TEndpoint(const NYP::NClient::TEndpointSet& set, const NYP::NClient::TPod& pod,
                     const NYP::NClient::NApi::NProto::TPodStatus::TIP6AddressAllocation& ip6Addr) {
    D_.PodId_ = pod.Meta().id();
    K_.EndpointSetId_ = set.Meta().id();
    K_.Fqdn_ = ip6Addr.persistent_fqdn();
    if (ip6Addr.internet_address().has_ip4_address()) {
        K_.Ip4Address_ = ip6Addr.internet_address().ip4_address();
    }
    K_.Ip6Address_ = ip6Addr.address();
    K_.Protocol_ = set.Spec().protocol();
    K_.Port_ = set.Spec().port();
}

void TEndpoint::Load(const NYP::NClient::TEndpoint& e) {
    D_.EndpointId_ = e.Meta().id();
    D_.PodId_ = TString();
    K_.EndpointSetId_ = e.Meta().endpoint_set_id();
    K_.Fqdn_ = e.Spec().fqdn();
    if (e.Spec().has_ip4_address()) {
        K_.Ip4Address_ = e.Spec().ip4_address();
    }
    K_.Ip6Address_ = e.Spec().ip6_address();
    K_.Protocol_ = e.Spec().protocol();
    K_.Port_ = e.Spec().port();
    K_.Ready_ = e.Status().ready();
}

void TEndpoint::Save(NYP::NClient::TEndpoint& e) const {
    e.MutableMeta()->set_endpoint_set_id(K_.EndpointSetId_);
    e.MutableSpec()->set_fqdn(K_.Fqdn_);
    if (K_.Ip4Address_.Defined()){
        e.MutableSpec()->set_ip4_address(*K_.Ip4Address_);
    }
    e.MutableSpec()->set_ip6_address(K_.Ip6Address_);
    e.MutableSpec()->set_protocol(K_.Protocol_);
    e.MutableSpec()->set_port(K_.Port_);
    if (D_.IsSyncedToYP()) {
        e.MutableMeta()->set_id(D_.EndpointId_);
    }
    e.MutableStatus()->set_ready(K_.Ready_);
}

} // namespace NInfra::NServiceController
