#pragma once

#include <yp/cpp/yp/data_model.h>
#include <yp/cpp/yp/request_model.h>

#include <util/digest/multi.h>

namespace NInfra::NServiceController {

class TEndpointKey {
public:
    struct THash;
    struct TEqualTo;

private:
    TString EndpointSetId_;
    TString Fqdn_;
    TMaybe<TString> Ip4Address_;
    TString Ip6Address_;
    TString Protocol_;
    ui32 Port_;
    bool Ready_;

    friend class TEndpoint;
};

class TEndpointData {
public:
    void Sync(const TEndpointData& data);

    bool IsSyncedToYP() const {
        return !EndpointId_.empty();
    }

    void DropPodRelation() {
        PodId_ = TString();
    }

    const TString& EndpointId() const {
        return EndpointId_;
    }

    const TString& PodId() const {
        return PodId_;
    }

    void SetPodId(const TString& podId) {
        PodId_ = podId;
    }

private:
    TString EndpointId_;
    TString PodId_;

    friend class TEndpoint;
};

class TEndpoint {
public:
    TEndpoint() = default;

    TEndpoint(const NYP::NClient::TEndpointSet& set, const NYP::NClient::TPod& pod,
              const NYP::NClient::NApi::NProto::TPodStatus::TIP6AddressAllocation& ip6Addr);

    TEndpoint(const TEndpointKey& key, const TEndpointData& data)
        : K_(key)
        , D_(data)
    {
    }

    const TEndpointKey& Key() const {
        return K_;
    }

    TEndpointData& Data() {
        return D_;
    }

    const TEndpointData& Data() const {
        return D_;
    }

    void Load(const NYP::NClient::TEndpoint& endpoint);
    void Save(NYP::NClient::TEndpoint& endpoint) const;

    void SetReady(const bool ready) {
        K_.Ready_ = ready;
    }

private:
    TEndpointKey K_;
    TEndpointData D_;
};

#define ENDPOINT_TIE(e) e.EndpointSetId_, e.Protocol_, e.Fqdn_, e.Ip4Address_, e.Ip6Address_, e.Port_, e.Ready_

struct TEndpointKey::THash {
    ui64 operator()(const TEndpointKey& e) const {
        return MultiHash(ENDPOINT_TIE(e));
    }
};

struct TEndpointKey::TEqualTo {
    bool operator()(const TEndpointKey& e1, const TEndpointKey& e2) const {
        return std::tie(ENDPOINT_TIE(e1)) == std::tie(ENDPOINT_TIE(e2));
    }
};

#undef ENDPOINT_TIE

} // namespace NInfra::NServiceController
