#pragma once

#include "endpoint.h"

#include <infra/libs/logger/log_frame.h>
#include <yp/cpp/yp/data_model.h>

#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/generic/vector.h>

namespace NInfra::NServiceController {

class TEndpointSetController {
public:
    TEndpointSetController(const NYP::NClient::TEndpointSet& set)
        : EndpointSet_(set)
    {
    }

    void GenerateUpdates(
        const TVector<NYP::NClient::TEndpoint>& endpoints
        , const TVector<NYP::NClient::TPod>& pods
        , TVector<NYP::NClient::TEndpoint>& insert
        , TVector<TString>& remove
        , const TAtomicSharedPtr<const THashSet<TString>> podsWithPodAgent
        , TLogFramePtr frame
    );

    const NYP::NClient::TEndpointSet& EndpointSet() const {
        return EndpointSet_;
    }

private:
    NYP::NClient::TEndpointSet EndpointSet_;
};

} // namespace NInfra::NServiceController
