import argparse
import json
import os

from yp.client import YpClient

WHITELIST_PATH = "config_whitelist.json"


def whitelist(yp_client):
    continuation_token = None
    limit = 5000
    timestamp = yp_client.generate_timestamp()
    fields = set()

    while True:
        objects = yp_client.select_objects('endpoint_set', selectors=['/spec/pod_filter'],
                                           filter='[/spec/pod_filter] != #',
                                           timestamp=timestamp,
                                           limit=limit,
                                           options={'continuation_token': continuation_token},
                                           enable_structured_response=True)

        continuation_token = objects['continuation_token']

        for endpoint_set in objects['results']:
            path = ''
            for char in endpoint_set[0]['value']:
                if char == ']':
                    fields.add(path)
                    path = ''
                    opened = False
                elif char == '[':
                    opened = True
                elif opened:
                    path += char
            if path:
                fields.add(path)

        if len(objects['results']) < limit:
            break

    fields = sorted(list(fields))
    no_duplicate_fields = list()

    if fields:
        no_duplicate_fields.append(fields[0])

    for i in range(len(fields)):
        for j in range(i + 1, len(fields)):
            if not fields[j] == fields[i] and not fields[j].startswith(fields[i] + "/"):
                no_duplicate_fields.append(fields[j])
                i = j - 1
                break

    return no_duplicate_fields


def print_whitelist(whitelist, path=WHITELIST_PATH):
    with open(path, 'w') as write_file:
        json.dump(whitelist, write_file, indent=4)


def parse_args():
    parser = argparse.ArgumentParser(description='Endpoint_sets pod_filter fields on YP clusters')
    parser.add_argument('-c', '--clusters',
                        help='YP cluster names')

    args = parser.parse_args()

    if args.clusters is not None:
        args.clusters = args.clusters.split(',')

    return args


def main():
    args = parse_args()

    cluster_2_paths = dict()

    for cluster in args.clusters:
        yp_client = YpClient(address='{}.yp.yandex.net:8090'.format(cluster), config={'token': os.environ['YP_TOKEN']})

        cluster_2_paths[cluster] = whitelist(yp_client)

    print_whitelist({"Whitelist": cluster_2_paths})
