import json

from libcpp cimport bool
from util.generic.string cimport TStringBuf


cdef extern from "infra/service_controller/libs/standalone_controller/standalone_controller.h" namespace "NInfra::NServiceController":
    cdef cppclass TStandaloneControllerWrapper:
        TStandaloneControllerWrapper(TStringBuf) except +
        void Sync()
        bool SafeSync()

cdef class StandaloneController:
    cdef TStandaloneControllerWrapper* _impl

    def __cinit__(self, config):
        json_string = bytes(json.dumps(config), 'utf-8')
        self._impl = new TStandaloneControllerWrapper(json_string)

    def sync(self):
        self._impl.Sync()

    def safe_sync(self):
        return self._impl.SafeSync()

    def __dealloc__(self):
        del self._impl
