#pragma once

#include <infra/service_controller/libs/config/config.pb.h>
#include <infra/service_controller/libs/controller/controller.h>

#include <infra/libs/controller/standalone_controller/standalone_controller.h>

#include <library/cpp/proto_config/config.h>

namespace NInfra::NServiceController {

NController::TSingleClusterObjectManagersFactoryPtr CreateFactory(NUpdatableProtoConfig::TAccessor<TConfig> config) {
    const size_t numberOfShards = config.Get()->GetShardsConfig().GetNumberOfShards();
    const NInfra::NLeadingInvader::TConfig livenessLeadingInvaderConfig = config.Get()->GetShardsConfig().GetLivenessLeadingInvader();
    bool managedByMaster = config.Get()->GetShardsConfig().GetManagedByMaster();
    const TString ensureShardMasterIsAliveTimeout = config.Get()->GetShardsConfig().GetEnsureShardMasterLivenessTimeout();

    NInfra::NController::TSharding shardsFactory(config.Get()->GetController().GetLeadingInvader(), livenessLeadingInvaderConfig, numberOfShards, managedByMaster, ensureShardMasterIsAliveTimeout);

    return new TEndpointSetManagerFactory(
        config.Accessor<TEndpointSetManagerFactoryConfig>("EndpointSetManagerFactory")
        , shardsFactory.GetShard(0)
    );
}

class TStandaloneController: public NInfra::NController::TStandaloneController {
public:
    TStandaloneController(NUpdatableProtoConfig::TAccessor<TConfig> config)
        : NInfra::NController::TStandaloneController(
            CONFIG_SNAPSHOT_VALUE(config, GetController())
            , CreateFactory(config)
        )
    {
    }
};

class TStandaloneControllerWrapper: public NInfra::NController::TStandaloneControllerWrapper<TStandaloneController, TConfig> {
    using NInfra::NController::TStandaloneControllerWrapper<TStandaloneController, TConfig>::TStandaloneControllerWrapper;
};

} // namespace NInfra::NServiceController
