#include <infra/service_controller_shard_master/libs/daemon/main.h>

#include <infra/libs/logger/log_printer.h>
#include <infra/libs/sensors/sensor_registry.h>

#include <library/cpp/getopt/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char* argv[]) {
    NInfra::SetSensorRegistryCommonGroup({"shard_master"});

    TModChooser modChooser;

    modChooser.AddMode(
        "run",
        NInfra::NServiceController::NShardMaster::RunDaemon,
        "Run ServiceController daemon."
    );

    modChooser.AddMode(
        "print_log",
        NInfra::PrintEventLog,
        "Print ServiceController log."
    );

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}

