import logging

from gevent.pywsgi import WSGIServer
import json


def serve_forever(callback, endpoint):
    def serve_request(env, start_response):
        path = env['PATH_INFO']
        if path in ['/status', '/status_message']:  # /status_message for old instancestate compatibility
            start_response('200 OK', [('Content-Type', 'application/json')])
            return [json.dumps(callback(), indent=4)]
        else:
            start_response('404 Not Found', [])
            return []

    WSGIServer(endpoint, serve_request, log=logging.getLogger('httpserver')).serve_forever()


if __name__ == '__main__':
    import gevent

    gevent.spawn(serve_forever, ('localhost', 7767), lambda: 42)
    gevent.sleep(100000)
