from infra.shawshank.proto import tuns_pb2

# TODO: choose these values wisely
DEFAULT_AWACS_OUTBOUND_TUNNEL_RULES_PRIORITY = 256
DEFAULT_AWACS_OUTBOUND_TUNNEL_TABLE_ID_OFFSET = 200
DEFAULT_AWACS_OUTBOUND_TUNNEL_MTU = 1450
MAX_AWACS_OUTBOUND_TUNNELS_NUMBER = 16
# outbound tunnel table identifiers will be in the range of
# [DEFAULT_AWACS_OUTBOUND_TUNNEL_TABLE_ID_OFFSET,
#  DEFAULT_AWACS_OUTBOUND_TUNNEL_TABLE_ID_OFFSET + MAX_AWACS_OUTBOUND_TUNNELS_NUMBER)


def _awacs_route_pb_to_internal_pb(awacs_route, route):
    route.iface = awacs_route.iface
    route.mtu = awacs_route.mtu
    route.advmss = awacs_route.advmss
    route.mpls_labels.extend(awacs_route.mpls_labels)


def awacs_instance_spec_pb_to_internal_pb(awacs_instance_spec_pb):
    """
    :type awacs_instance_spec_pb: infra.awacs.proto.model_pb2.BalancerContainerSpec
    :rtype: tuns_pb2.ContainerSpec
    """
    pb = tuns_pb2.ContainerSpec()
    assert len(awacs_instance_spec_pb.outbound_tunnels) < MAX_AWACS_OUTBOUND_TUNNELS_NUMBER
    rule_offset = 0
    for i, awacs_tunnel_pb in enumerate(awacs_instance_spec_pb.outbound_tunnels):
        tunnel_pb = pb.tunnels.add()
        tunnel_pb.name = awacs_tunnel_pb.id
        tunnel_pb.remote_ip = awacs_tunnel_pb.remote_ip
        for awacs_rule_pb in awacs_tunnel_pb.rules:
            rule = tunnel_pb.rules.add(
                from_ip=awacs_rule_pb.from_ip,
                to_ip=awacs_rule_pb.to_ip,
                table_id=DEFAULT_AWACS_OUTBOUND_TUNNEL_TABLE_ID_OFFSET + i,
                priority=DEFAULT_AWACS_OUTBOUND_TUNNEL_RULES_PRIORITY + rule_offset,
            )
            _awacs_route_pb_to_internal_pb(awacs_rule_pb.default_v4_route, rule.default_v4_route)
            _awacs_route_pb_to_internal_pb(awacs_rule_pb.default_v6_route, rule.default_v6_route)
            rule_offset += 1

        if awacs_tunnel_pb.mode == awacs_tunnel_pb.IPIP6:
            tunnel_pb.mode = tunnel_pb.IPIP6
        elif awacs_tunnel_pb.mode == awacs_tunnel_pb.IP6IP6:
            tunnel_pb.mode = tunnel_pb.IP6IP6
        elif awacs_tunnel_pb.mode == awacs_tunnel_pb.ANY:
            tunnel_pb.mode = tunnel_pb.ANY
        else:
            raise AssertionError('unknown `awacs_tunnel_pb.mode`')
        tunnel_pb.mtu = awacs_tunnel_pb.mtu or DEFAULT_AWACS_OUTBOUND_TUNNEL_MTU
        tunnel_pb.advmss = awacs_tunnel_pb.advmss
        tunnel_pb.encap.type = awacs_tunnel_pb.encap.type
        tunnel_pb.encap.sport = awacs_tunnel_pb.encap.sport
        tunnel_pb.encap.dport = awacs_tunnel_pb.encap.dport
        tunnel_pb.encap.limit = awacs_tunnel_pb.encap.limit

    for awacs_vip in awacs_instance_spec_pb.virtual_ips:
        vip_pb = pb.virtual_ips.add()
        vip_pb.ip = awacs_vip.ip
        vip_pb.desc = awacs_vip.description

    _awacs_route_pb_to_internal_pb(awacs_instance_spec_pb.default_v4_route, pb.default_v4_route)
    _awacs_route_pb_to_internal_pb(awacs_instance_spec_pb.default_v6_route, pb.default_v6_route)

    return pb
