import netaddr
import logging
from pyroute2 import IPRoute

# version: (device name, mask/prefixlen)
addr_version_device = {
    4: ('tun0', 32),
    6: ('ip6tnl0', 128),
}


def get_device_index(iface_name):
    with IPRoute() as ipr:
        try:
            idx = ipr.link_lookup(ifname=iface_name)[0]
            return idx
        except IndexError:
            logging.info('No such devive: {}'.format(iface_name))


def add_vips(container_spec, flush=True):
    idxs = {}  # {device_name: device_index}
    for dev, _ in addr_version_device.values():
        idx = get_device_index(dev)
        if idx is None:
            raise Exception('No such device: {}'.format(dev))
        idxs[dev] = idx

    if flush:
        with IPRoute() as ipr:
            for idx in idxs.values():
                ipr.flush_addr(index=idx)

    for i in container_spec.virtual_ips:
        logging.info('{}: {}'.format(i.desc, i.ip))
        family = netaddr.IPAddress(i.ip).version
        device, mask = addr_version_device[family]
        try:
            with IPRoute() as ipr:
                ipr.addr(
                    "add",
                    address=i.ip,
                    index=idxs[device],
                    mask=mask,
                )
        except Exception as e:
            if e[0] == 17:  # python2
                logging.info("{} already exists".format(i.ip))
                continue
            else:
                raise
