from .component import ComponentLoggerAdapter


def _add_uid_prefix_if_needed(uid, msg):
    prefix = '[res:%s]' % (uid[:8], )
    if msg.startswith(prefix):
        return msg
    return '%s  %s' % (prefix, msg)


class ResourceIdLoggerAdapter(ComponentLoggerAdapter):
    def __init__(self, logger, extra):
        super(ResourceIdLoggerAdapter, self).__init__(logger, extra)

    def process(self, msg, kwargs):
        return _add_uid_prefix_if_needed(self.extra.get('uid', ''), msg), kwargs


class WorldLoggerAdapter(ComponentLoggerAdapter):
    def process(self, msg, kwargs):
        uid = self.extra.get('world_uid')
        desc = self.extra.get('world_desc')

        if desc:
            msg = '[%-40s] %s' % (desc, msg)
        else:
            msg = '[%8s] [%-40s] %s' % (uid[:8], desc or '', msg)

        return msg, kwargs


class HandleLoggerAdapter(WorldLoggerAdapter):
    def __init__(self, logger, extra):
        super(HandleLoggerAdapter, self).__init__(logger, extra)

    def process(self, msg, kwargs):
        return '[res:%s]  %s' % (self.extra.get('uid', '')[:8], msg), kwargs
