import gevent

from kernel.util import logging


root_logger = logging.getLogger()

log = root_logger.getChild('copier')
log.normal = log.info


class SmartLoggerAdapter(logging.LoggerAdapter):
    def __init__(self, logger, extra):
        super(SmartLoggerAdapter, self).__init__(logger, extra)
        # self.name = logger.name  py3-mcsl: cant set attrib

    def get_child(self, *args, **kwargs):
        return type(self)(self.logger.getChild(*args, **kwargs), self.extra)

    def get_parent(self):
        get_parent = getattr(self.logger, 'get_parent', None)
        parent = get_parent() if get_parent else self.logger.parent
        if parent is None:
            return None
        return type(self)(parent, self.extra)

    def get_local(self, key):
        grn = gevent.getcurrent()
        local = getattr(grn, 'slocal', getattr(grn, 'tlocal', {}))
        return local.get(key)

    getChild = get_child


class JobUidAdapter(SmartLoggerAdapter):
    def process(self, msg, kwargs):
        resource_uid = self.get_local('resource_uid')
        if not resource_uid:
            resource = self.get_local('resource')
            if resource:
                resource_uid = resource.uid

        if resource_uid and resource_uid not in msg:
            msg = '[resid:%s] %s' % (resource_uid, msg)

        job_uid = self.get_local('job_uid')
        job_name = self.get_local('job_name')

        if job_name == 'resource_info':
            job_name = 'info'
        elif job_name == 'resource_download':
            job_name = 'dl'
        elif job_name == 'resource_create':
            job_name = 'create'

        if job_uid:
            msg = '[jb]{%s:%s}  %s' % (str(job_uid).split('-', 1)[0], job_name, msg)

        return msg, kwargs


log = JobUidAdapter(log, {})
log.normal = log.info


def fix_logger_name(name):
    deprecated_name = 'ya.skynet.services.copier.rbtorrent'
    new_name = 'skbn'

    if name.startswith(deprecated_name):
        name = new_name + name[len(deprecated_name):]

    return name


def adapt_logger(logger):
    return JobUidAdapter(logger, {})
