import gevent
import gevent.event

from .component import Component

from .shmem import SharedMemory


class Lookup(Component):
    def __init__(
        self,
        lookup_head_cb,
        get_block,
        parent=None
    ):
        self.lookup_head_cb = lookup_head_cb
        self.get_block = get_block
        self.buffer_watcher = None
        self.buffer_watcher_ready = gevent.event.Event()
        self.shared_memory = SharedMemory()
        self.shared_memory.create_mmap(64 * 1024 * 1024)

        super(Lookup, self).__init__(logname='lookup', parent=parent)

    def look_head(self, uid):
        # Should return None, None or head (bencoded string) + info (dict)
        return self.lookup_head_cb(uid), None
