import py


class Path(py.path.local):
    strpath = None

    def ensure(self, *args, **kwargs):
        if kwargs.get('nolink', 0):
            p = self.join(*args)
            if p.check(link=1):
                p.remove()

        try:
            return super(Path, self).ensure(*args, **kwargs)
        except (py.error.EEXIST, py.error.EISDIR):
            if kwargs.get('force', 0):
                self.join(*args).remove()
                return super(Path, self).ensure(*args, **kwargs)
            else:
                raise

    @classmethod
    def sysfind(cls, *args, **kwargs):
        return py.path.local.sysfind(*args, **kwargs)
