import sys

from kernel.util import logging

import api.logger
import os.path


FORMATTERS = {
        'colored' : __import__('kernel.util.logging', fromlist=['ColoredFormatter']).ColoredFormatter(
        fmt='%(asctime)s %(levelname)s %(name)s   %(message)s',
        fmtName='[%(name)-21s]',
        fmtLevelname='[%(levelname)-1s]',
        fmtAsctime='%(datetime)s.%(msecs)003d',
        hungryLevels={
            'info': ['message'],
            'debug': ['message'],
            'warning': ['message'],
            'error': ['message', 'name']
        }
        ),
        'full' : logging.Formatter(fmt='%(asctime)s : %(levelname)-8s : %(name)s : %(message)s')
    }


def get_formatter(formatter_name):
    formatter = FORMATTERS.get(formatter_name) 
    if formatter is not None:
        return formatter
    return FORMATTERS.get('full')

def setup_logging(progname, console_verbosity=0, logpath=None):
    logging.renameLevels(1)
    logging.captureWarnings(True)

    root_logger = logging.getLogger('')
    root_logger.setLevel(logging.DEBUG)
    root_logger.name = ''

    console_handler = logging.StreamHandler(sys.stderr)
    console_handler.setLevel(logging.CRITICAL - console_verbosity * 10)
    console_handler.setFormatter(get_formatter('colored'))
    root_logger.addHandler(console_handler)
  
    #Customizable logging
    if logpath is not None:
        custom_file_handler = logging.handlers.RotatingFileHandler(os.path.join(logpath, progname+'.log'), maxBytes=0.75*(1<<30), backupCount=2)
        custom_file_handler.setLevel(logging.DEBUG)
        custom_file_handler.setFormatter(get_formatter('full'))
        root_logger.addHandler(custom_file_handler)
        return root_logger, custom_file_handler.stream.fileno()

    skynet_handler = api.logger.SkynetLoggingHandler(app=progname, filename=progname + '.log')
    skynet_handler.setLevel(logging.DEBUG)
    root_logger.addHandler(skynet_handler)

    return root_logger, None