import flask
import gevent.wsgi
import logging


class WebGui(object):
    def __init__(self, path, port, stats):
        self.path = path
        self.port = port
        self.log = logging.getLogger('web')
        self.sock = None
        self._stats = stats

    def start(self):
        self.sock = gevent.socket.socket(gevent.socket.AF_INET6, gevent.socket.SOCK_STREAM)
        self.sock.setsockopt(gevent.socket.IPPROTO_IPV6, gevent.socket.IPV6_V6ONLY, False)
        self.sock.setsockopt(gevent.socket.SOL_SOCKET, gevent.socket.SO_REUSEADDR, 1)
        self.sock.bind(('', self.port))
        self.sock.listen(gevent.socket.SOMAXCONN)

        self._app = flask.Flask(
            __name__,
            instance_path=self.path.strpath,
            template_folder=self.path.join('share', 'templates').strpath,
            static_folder=self.path.join('share', 'static').strpath,
            static_url_path='/static'
        )
        self._app.config.update({
            'DEBUG': True,
            'TESTING': True,
            'PROPAGATE_EXCEPTIONS': True,
            'LOGGER_NAME': 'web',
            'MAX_CONTENT_LENGTH': 2 * 1024 * 1024,
        })

        self._app.add_url_rule('/', view_func=self.web_index)

        self._wsgi = gevent.wsgi.WSGIServer(
            self.sock,
            application=self._app,
            log=None
        )
        self._wsgi.start()

        self.log.info('Started wsgi server on 0.0.0.0:%d', self.port)

        return self

    def stop(self):
        self._wsgi.stop(timeout=3)
        return self

    def join(self):
        return self

    def web_index(self):
        output = '<!DOCTYPE html>'
        output += '<html lang="en">'
        output += '<style type="text/css">'
        output += 'body { font-family: Arial }'
        #output += 'td, th { padding: 3px 1em; }'

        output += 'th { text-align: center; }'
        output += 'td.v { text-align: right; }'
        output += '</style>'
        output += (
            '<link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.1.1/css/bootstrap.min.css">'
            '<link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.1.1/css/bootstrap-theme.min.css">'
            '<script src="//netdna.bootstrapcdn.com/bootstrap/3.1.1/js/bootstrap.min.js"></script>'
        )
        output += '<body>'

        output += '<div class="container">'

        output += '<div class="row">'
        output += '<div class="col-md-12">'
        output += '<h1>skybone.coord</h1>'

        for section, stats in self._stats().iteritems():
            output += '<h2>' + str(section) + '</h2>'
            output += '<table class="table table-bordered table-condensed">'

            columns = []

            output += '<tr><td></td>'
            for kstats in stats.itervalues():
                for frame, _ in kstats.iteritems():
                    if frame not in columns:
                        columns.append(frame)
                        output += '<th>' + str(frame) + '</th>'
            output += '</tr>'

            for key, kstats in stats.iteritems():
                unit = kstats.values()[0][2]
                output += '<tr><td>'
                if unit:
                    output += '%s (%s)' % (key, unit)
                else:
                    output += str(key)

                for col in columns:
                    output += '<td class="v">'
                    if col in kstats:
                        output += str(kstats[col][0])
                    else:
                        output += '<span class="text-muted">-</span>'
                    output += '</td>'

                output += '</td></tr>'
            output += '</table>'

        output += '</div></div></div>'
        output += '</body></html>'
        return output
