import ipaddress

from enum import Enum

from .nets import SAS_NETS, VLA_NETS, MAN_NETS, IVA_NETS, MYT_NETS


class DC(Enum):
    NONE = 0
    IVA = 1
    MYT = 2
    SAS1 = 3
    VLA = 4
    MAN = 5


DC_NETS = {
    DC.NONE: {},
    DC.SAS1: SAS_NETS,
    DC.VLA: VLA_NETS,
    DC.MAN: MAN_NETS,
    DC.IVA: IVA_NETS,
    DC.MYT: MYT_NETS,
}


def determine_dc(ip, log=None):
    if ip is None:
        return DC.NONE

    try:
        ip = ipaddress.ip_address(unicode(ip))
    except Exception as ex:
        if log:
            log.warning('failed to create ipaddress from %s: %s', ip, ex)
        return DC.NONE

    for dc, nets in DC_NETS.items():
        for net in nets:
            if ip in net:
                return dc

    return DC.NONE
