#!/bin/sh

DEPENDENCIES="api"

set -e

case "$1" in
    dep*)
        echo ${DEPENDENCIES}
        exit 0
        ;;
esac

if [ -z "$VARIANT" ]; then
    VARIANT=$(basename $(pwd))
    if [ "$VARIANT" = "copier" ]; then
        VARIANT=skybone
    fi
fi

export VARIANT

cmdf="tools/bin/$1"

if [ -x "$cmdf" ] && [ ! -d "$cmdf" ]; then
    shift 1
    exec "$cmdf" "$@"
fi

echo "Available commands:"
find tools/bin -type f -perm /+x | awk -F '/' '{print " - " $3}'
