#!/usr/bin/env bash

root=$1
path=$2

perm_user=$3
perm_group=$4
perm_mask=$5

perm2_user=$6
perm2_group=$7
perm2_mask=$8

if [ ! "$(id -u)" = "0" ]; then
    perm2_user=""
    perm2_group=""
    perm2_mask=""
fi

src=$root/tools/skybone-ctl
tgt=$path/bin/skybone-admin

if [ ! -f "$tgt" ]; then
    src=$root/tools/skybone-mds-ctl
    tgt=$path/bin/skybone-mds-admin
fi

echo "Making symlink \"$src\" -> \"$tgt\""
rm -rf "$src"
ln -sf "$tgt" "$src"
[ -n "$perm2_user" ] && chown -h $perm2_user:$perm2_group "$src"

exit 0
