import os
import sys

try:
    from setuptools import setup, find_packages
except ImportError:
    print >> sys.stderr, 'Please install distribute from PyPi first.'
    exit(1)


NS_PKG_STUB = '__import__("pkg_resources").declare_namespace(__name__)'


from setuptools.command.bdist_egg import log
from setuptools.command.install import install


class InstallCommand(install):
    def run(self):
        install.run(self)

        for path, dirs, files in os.walk(self.install_purelib):
            if path == self.install_purelib:
                continue

            if '__init__.py' not in files:
                pkg = path[len(self.install_purelib):].replace(os.sep, '.')
                if self.distribution.has_contents_for(pkg):
                    log.warn('Creating missing __init__.py for %s', pkg)
                    fn = os.path.join(path, '__init__.py')
                    if not self.dry_run:
                        with open(fn, 'w') as f:
                            f.write(NS_PKG_STUB)


setup(
    name='skybone-mds',
    version='2.0',
    description='Skynet Skybone (mds variant)',
    install_requires=[
        'py',
        'gevent>=0.13.6,<1',
        'Pyro4==4.8',
        'msgpack-python',
        'PyYAML',
    ] if sys.platform == 'cygwin' else [
        'py',
        'gevent>=0.13.6,<1',
        'Pyro4==4.8',
        'msgpack-python',
        'psutil>=0.4.1',
        'PyYAML',
    ],
    packages=(
        ['skybone_mds.%s' % pkg for pkg in find_packages('src')] +
        ['skybone_mds.kernel_util'] +
        ['skybone_mds.kernel_util.%s' % package for package in find_packages('build/kernel_util')]
    ),
    package_dir={
        'skybone_mds': 'src',
        'skybone_mds.kernel_util': 'build/kernel_util'
    },
    entry_points={
        'console_scripts': [
            'skybone-mds = skybone_mds.mds.daemon:main',
            'skybone-mds-admin = skybone_mds.mds.client.admin:main',
        ],
    },
    cmdclass={'install': InstallCommand}
)
