import os
import sys

try:
    from setuptools import setup, find_packages
except ImportError:
    print >> sys.stderr, 'Please install distribute from PyPi first.'
    exit(1)


NS_PKG_STUB = '__import__("pkg_resources").declare_namespace(__name__)'


from setuptools.command.bdist_egg import log
from setuptools.command.install import install


class InstallCommand(install):
    def run(self):
        install.run(self)

        for path, dirs, files in os.walk(self.install_purelib):
            if path == self.install_purelib:
                continue

            if '__init__.py' not in files:
                pkg = path[len(self.install_purelib):].replace(os.sep, '.')
                if self.distribution.has_contents_for(pkg):
                    log.warn('Creating missing __init__.py for %s', pkg)
                    fn = os.path.join(path, '__init__.py')
                    if not self.dry_run:
                        with open(fn, 'w') as f:
                            f.write(NS_PKG_STUB)


setup(
    name='skybone',
    version='2.0',
    description='Skynet Skybone',
    install_requires=[
        'py',
        'gevent>=0.13.6',
        'Pyro4==4.8',
        'msgpack-python',
        'PyYAML',
    ] if sys.platform == 'cygwin' else [
        'py',
        'gevent>=0.13.6',
        'Pyro4==4.8',
        'msgpack-python',
        'psutil>=0.4.1',
        'pycryptodome',
        'PyYAML',
        'directio==1.2',
        'enum34',
        'ipaddress',
        'xxhash<3.0.0',  # 3.0.0 dropped support for py2
        'apsw==3.9.2-r1',
        'zstandard<0.15.0',  # 0.15.0 dropped support for py2
    ],
    packages=(
        ['skybone.%s' % pkg for pkg in find_packages('src')] +
        ['skybone.kernel_util'] +
        ['skybone.kernel_util.%s' % package for package in find_packages('build/kernel_util')]
    ),
    package_dir={
        'skybone': 'src',
        'skybone.kernel_util': 'build/kernel_util'
    },
    entry_points={
        'console_scripts': [
            'skybone = skybone.rbtorrent.daemon:main',
            'skybone-skybit = skybone.rbtorrent.skbn.daemon:main',
            'skybone-netproxy = skybone.rbtorrent.netproxy:main',
            'skybone-dl = skybone.rbtorrent.skbn.dl:main',
            'skybone-sh = skybone.rbtorrent.skbn.sh:main',
            'skybone-admin = skybone.client.admin:main',
        ],
    },
    cmdclass={'install': InstallCommand}
)
