DROP TABLE IF EXISTS file_new;

CREATE TABLE "file_new" (
    "path"          TEXT    NOT NULL,  -- path
    "data"          TEXT    NOT NULL,  -- data.id
    "mtime"         INTEGER NOT NULL,  -- inode mtime
    "chktime"       INTEGER NOT NULL,  -- last checking time

    PRIMARY KEY (path)      ON CONFLICT ABORT
    FOREIGN KEY (data)      REFERENCES data           ON DELETE CASCADE ON UPDATE RESTRICT
);

INSERT INTO file_new
    SELECT path, data, mtime, chktime FROM file;

DROP TABLE file;
ALTER TABLE file_new RENAME TO file;

CREATE INDEX idx__file__chktime ON file(chktime);
CREATE INDEX idx__file__data ON file(data);
