CREATE TABLE announce_tracker (
    id              INTEGER PRIMARY KEY,
    kind            TEXT    NOT NULL,
    host            TEXT    NOT NULL

    CHECK (kind in ("opentracker", "coord"))
);

CREATE TABLE announce (
    "resource"      TEXT    NOT NULL,  -- resource.id
    "hash"          TEXT    NOT NULL,  -- hash to announce (from resource structure)
    "timestamp"     INTEGER NOT NULL,  -- timestamp for next schedule
    "tracker"       INTEGER NOT NULL,  -- tracker identifier (ot:URI or cd:URI)

    PRIMARY KEY (resource, hash, tracker) ON CONFLICT ABORT
    FOREIGN KEY (tracker)   REFERENCES announce_tracker         ON DELETE CASCADE ON UPDATE RESTRICT
    FOREIGN KEY (resource)  REFERENCES resource                 ON DELETE CASCADE ON UPDATE RESTRICT
);

CREATE TABLE announce_stop (
    "hash"          TEXT    NOT NULL,
    "tracker"       INTEGER NOT NULL,
    "deadline"      INTEGER NOT NULL,

    PRIMARY KEY (hash, tracker) ON CONFLICT ABORT
    FOREIGN KEY (tracker)   REFERENCES announce_tracker         ON DELETE CASCADE ON UPDATE RESTRICT
);

-- Used in resyncing announce
CREATE INDEX idx__announce__resource ON announce (resource);

-- Used in each scheduler
CREATE INDEX idx__announce__tracker_timestamp ON announce (tracker, timestamp);
CREATE INDEX idx__announce_stop__tracker_deadline ON announce_stop (tracker, deadline);

-- For fast lookup via infohash. used in announce resulter loop
CREATE INDEX idx__announce__hash_tracker ON announce (hash, tracker);
