DROP TABLE IF EXISTS announce_new;

CREATE TABLE announce_new (
    "resource"      TEXT    NOT NULL,  -- resource id
    "timestamp"     INTEGER NOT NULL,  -- timestamp for next schedule
    "tracker"       INTEGER NOT NULL,  -- tracker identifier (ot:URI or cd:URI)

    PRIMARY KEY (resource, tracker) ON CONFLICT ABORT
    FOREIGN KEY (tracker)  REFERENCES announce_tracker          ON DELETE CASCADE ON UPDATE RESTRICT
    FOREIGN KEY (resource) REFERENCES resource                  ON DELETE CASCADE ON UPDATE RESTRICT
);

INSERT INTO announce_new
    SELECT resource, timestamp, tracker FROM announce WHERE resource = hash;

DROP TABLE announce;
ALTER TABLE announce_new RENAME TO announce;

-- Used in resyncing announce
CREATE INDEX idx__announce__resource ON announce (resource);

-- Used in each scheduler
CREATE INDEX idx__announce__tracker_timestamp ON announce (tracker, timestamp);

-- For fast lookup via infohash. used in announce resulter loop
CREATE INDEX idx__announce__resource_tracker ON announce (resource, tracker);

CREATE TABLE resource_data_new (
    "resource"      TEXT    NOT NULL,  -- resource.id
    "name"          TEXT    NOT NULL,  -- name of file
    "hash"          TEXT        NULL,  -- torrent infohash
    "data"          TEXT        NULL,  -- data.id
    "symlink"       TEXT        NULL,  -- symlink target
    "directory"     BOOL    NOT NULL,  -- directory target
    "perms"         INT     NOT NULL,  -- permissions (e.g. 0o640)

    PRIMARY KEY (resource, name) ON CONFLICT ABORT

    FOREIGN KEY (resource)  REFERENCES resource       ON DELETE CASCADE ON UPDATE RESTRICT
    FOREIGN KEY (data)      REFERENCES data           ON DELETE CASCADE ON UPDATE RESTRICT

    CONSTRAINT "exclusive-data-symlink-directory" CHECK (
        CASE (data IS NOT NULL)
            WHEN 1 THEN (symlink IS NULL AND NOT directory)
            WHEN 0 THEN CASE (symlink IS NOT NULL)
                WHEN 1 THEN (NOT directory)
                WHEN 0 THEN (directory)
            END
        END
    )
);

INSERT INTO resource_data_new
    SELECT resource, name, NULL, data, symlink, directory, perms FROM resource_data;

PRAGMA FOREIGN_KEYS=OFF;
DROP TABLE resource_data;
ALTER TABLE resource_data_new RENAME TO resource_data;

CREATE INDEX idx__resource_data__data ON resource_data (data);
CREATE INDEX idx__resource_data__resource ON resource_data (resource);
CREATE INDEX idx__resource_data__hash ON resource_data (hash);

PRAGMA FOREIGN_KEY_CHECK;
PRAGMA FOREIGN_KEYS=ON;
