def migrate(db, log):
    import msgpack

    resids = db.query_col('SELECT id FROM resource', log=False)

    log.info('  Resources count: %d', len(resids))

    with db(debug_sql=False, debug_transactions=True, transaction=False):
        for idx, resid in enumerate(resids):
            if idx % 1000 == 0:
                log.debug('    done %d from %d', idx, len(resids))

            data = db.query_one_col('SELECT data FROM resource WHERE id = ?', (resid, ))
            structure = msgpack.loads(data)['structure']

            for path, info in structure.iteritems():
                if 'resource' not in info:
                    continue
                if info['resource']['type'] != 'torrent':
                    continue

                infohash = info['resource']['id']

                db.query(
                    'UPDATE resource_data SET hash = ? WHERE resource = ? AND name = ?',
                    (infohash, resid, path)
                )
        log.debug('  finished')
