CREATE TABLE "announce" (
    "resource"      TEXT    NOT NULL,  -- resource id
    "timestamp"     INTEGER NOT NULL,  -- timestamp for next schedule
    "tracker"       INTEGER NOT NULL,  -- tracker identifier (ot:URI or cd:URI)

    PRIMARY KEY (resource, tracker) ON CONFLICT ABORT
    FOREIGN KEY (tracker)  REFERENCES announce_tracker          ON DELETE CASCADE ON UPDATE RESTRICT
    FOREIGN KEY (resource) REFERENCES resource                  ON DELETE CASCADE ON UPDATE RESTRICT
);
CREATE INDEX idx__announce__resource ON announce (resource);
CREATE INDEX idx__announce__resource_tracker ON announce (resource, tracker);
CREATE INDEX idx__announce__tracker_timestamp ON announce (tracker, timestamp);


CREATE TABLE announce_stop (
    "hash"          TEXT    NOT NULL,
    "tracker"       INTEGER NOT NULL,
    "deadline"      INTEGER NOT NULL,

    PRIMARY KEY (hash, tracker) ON CONFLICT ABORT
    FOREIGN KEY (tracker)   REFERENCES announce_tracker         ON DELETE CASCADE ON UPDATE RESTRICT
);
CREATE INDEX idx__announce_stop__tracker_deadline ON announce_stop (tracker, deadline);


CREATE TABLE announce_tracker (
    id              INTEGER PRIMARY KEY,
    kind            TEXT    NOT NULL,
    host            TEXT    NOT NULL

    CHECK (kind in ("opentracker", "coord"))
);


CREATE TABLE resource (
    "id"            TEXT    NOT NULL,   -- resource identifier (sha1 hash)
    "type"          TEXT    NOT NULL,   -- resource_type.type
    "data"          BLOB    NOT NULL,   -- resource head
    "info"          BLOB    NOT NULL,   -- resource info (files map, etc.)

    PRIMARY KEY (id)        ON CONFLICT ABORT
    FOREIGN KEY (type)      REFERENCES resource_type ON DELETE RESTRICT ON UPDATE RESTRICT
);


CREATE TABLE resource_type (
    type            TEXT    NOT NULL,
    PRIMARY KEY (type) ON CONFLICT ABORT
    CHECK (type IN ('rbtorrent1'))
) WITHOUT ROWID;

INSERT INTO resource_type VALUES ('rbtorrent1');
