import py


class Path(py.path.local):
    strpath = None

    def ensure(self, *args, **kwargs):
        if kwargs.get('nolink', 0):
            p = self.join(*args)
            if p.check(link=1):
                p.remove()

        try:
            return super(Path, self).ensure(*args, **kwargs)
        except (py.error.EEXIST, py.error.EISDIR):
            if kwargs.get('force', 0):
                self.join(*args).remove()
                return super(Path, self).ensure(*args, **kwargs)
            else:
                raise

    def join(self, *args, **kwargs):
        return super(Path, self).join(*args, **kwargs)

    @classmethod
    def sysfind(cls, *args, **kwargs):
        return py.path.local.sysfind(*args, **kwargs)

    def chmod(self, *args, **kwargs):
        return super(Path, self).chmod(*args, **kwargs)


def determine_app_path():
    import os

    app_path = os.environ.get('SKYBONE_APP_PATH')
    if app_path:
        return Path(app_path)

    fpath = Path(__file__)

    for part in reversed(fpath.parts()):
        if part.join('ctl.py').check(exists=1):
            return part

    raise Exception('Unable to find app path')
