from __future__ import absolute_import

import os

from py import std


PROGNAME = 'skybone (copier)'


def monkey_patch(gevent_log=True, os_fork=True, gevent_resolver=True, locale=True):
    # These imports here is to avoid importing gevent then importing
    # whole copier.rbtorrent package.
    import gevent
    import gevent.monkey

    if locale:
        # We have some spurious bugs with std::runtime_error and FreeBSD if
        # non-C locale defined..
        os.environ['LANG'] = 'C'
        os.environ['LC_ALL'] = 'C'

    if gevent_log:
        from .greenlet import Greenlet

        std.sys.modules['gevent'].Greenlet = Greenlet
        std.sys.modules['gevent.greenlet'].Greenlet = Greenlet

        for attr in (
            'Greenlet',
            'spawn',
            'spawn_later',
            'spawn_link',
            'spawn_link_value',
            'spawn_link_exception',
        ):
            if hasattr(Greenlet, attr):
                setattr(std.sys.modules['gevent'], attr, getattr(Greenlet, attr))
                setattr(std.sys.modules['gevent.greenlet'].Greenlet, attr, getattr(Greenlet, attr))

    if os_fork:
        gevent.monkey.patch_os()
        try:
            gevent.monkey.patch_signal()
            gevent.monkey.patch_subprocess()
        except AttributeError:
            # old gevent version
            pass

    if gevent_resolver:
        from .utils import getaddrinfo_g, gethostbyaddr_g
        import gevent.socket
        import _socket

        gevent.socket.gethostbyaddr = lambda *args, **kwargs: (
            kwargs.update({'gethostbyaddr': _socket.gethostbyaddr}) or gethostbyaddr_g(*args, **kwargs)
        )
        gevent.socket.getaddrinfo = lambda *args, **kwargs: (
            kwargs.update({'getaddrinfo': _socket.getaddrinfo}) or getaddrinfo_g(*args, **kwargs)
        )
