class IoSemaphore(object):
    def __init__(self, cli):
        self.cli = cli
        self.job = cli.call('io_semaphore')

    def acquire(self):
        self.job.send('acquire')
        self.job.next()

    def release(self):
        self.job.send('release')

    def __enter__(self):
        self.acquire()

    def __exit__(self, typ, val, tb):
        self.release()
