import os


if os.uname()[0].lower() == 'linux':
    import ctypes
    import ctypes.util

    POSIX_FADV_RANDOM = 1

    def fadv_random(fd):
        return ctypes.CDLL(None).posix_fadvise(fd, ctypes.c_uint64(0), ctypes.c_uint64(0), POSIX_FADV_RANDOM)

else:
    def fadv_random(fd):
        pass
