import os
import ctypes
import ctypes.util

if os.uname()[0].lower() == 'linux':
    c_off_t = ctypes.c_int64

    def make_fallocate():
        libc = ctypes.CDLL(None, use_errno=True)
        posix_mode = False

        try:
            _fallocate = libc.fallocate
            _fallocate.restype = ctypes.c_int
            _fallocate.argtypes = [ctypes.c_int, ctypes.c_int, c_off_t, c_off_t]
        except:
            posix_mode = True
            _fallocate = libc.posix_fallocate
            _fallocate.restype = ctypes.c_int
            _fallocate.argtypes = [ctypes.c_int, c_off_t, c_off_t]

        del libc

        def fallocate(fd, mode, offset, len_):
            if not posix_mode:
                res = _fallocate(fd if isinstance(fd, int) else fd.fileno(), mode, offset, len_)
            else:
                res = _fallocate(fd if isinstance(fd, int) else fd.fileno(), offset, len_)

            if res != 0:
                errcode = ctypes.get_errno()
                if errcode < 0:
                    errcode = res
                raise IOError(errcode, 'fallocate failed')

        return fallocate

    fallocate = make_fallocate()
    del make_fallocate

    FALLOC_FL_KEEP_SIZE = 0x01
    FALLOC_FL_PUNCH_HOLE = 0x02
else:
    fallocate = None
