import inspect
import py


def migrate_workdir_if_needed(copier):
    log = copier.log.getChild('migrate')

    version_file = copier.workdir.join('.version')
    try:
        version = int(version_file.read(mode='rb'))
    except (py.error.ENOENT, ValueError):
        version = 0

    version_now = 3
    version_before = version

    if version_now > version:
        step = 1
    elif version_now < version:
        step = -1
    else:
        # no migration needed
        return

    for v in range(version_before, version_now, step):
        try:
            submod = 'migrate_workdir_%d_to_%d' % (v, v + step)
            meth = getattr(__import__(__name__, fromlist=[submod]), submod).migrate
        except (ImportError, AttributeError):
            log.warning('no migration script to migrate workdir %d => %d, skip', v, v + step)
            version_file.write('%d\n' % (v + step, ))
        else:
            args = inspect.getargspec(meth).args

            kwargs = {}

            if 'workdir' in args:
                kwargs['workdir'] = copier.workdir

            if 'db' in args:
                kwargs['db'] = copier.db

            log.info('Migrating workdir %d => %d', v, v + step)
            meth(**kwargs)
            version_file.write('%d\n' % (v + step, ))
