import ipaddress

from enum import Enum

from . import nets


class DC(Enum):
    NONE = 0
    IVA = 1
    MYT = 2
    SAS1 = 3
    VLA = 4
    MAN = 5
    AZURE_USEAST = 6
    AZURE_WESTEU = 7
    AZURE_SEASIA = 8


DC_NETS = {
    DC.NONE: {},
    DC.SAS1: nets.SAS_NETS,
    DC.VLA: nets.VLA_NETS,
    DC.MAN: nets.MAN_NETS,
    DC.IVA: nets.IVA_NETS,
    DC.MYT: nets.MYT_NETS,
    DC.AZURE_USEAST: nets.AZURE_USEAST_NETS,
    DC.AZURE_WESTEU: nets.AZURE_WESTEU_NETS,
    DC.AZURE_SEASIA: nets.AZURE_SEASIA_NETS,
}


def determine_dc(ip, log=None):
    if ip is None:
        return DC.NONE

    try:
        ip = ipaddress.ip_address(unicode(ip))
    except Exception as ex:
        if log:
            log.warning('failed to create ipaddress from %s: %s', ip, ex)
        return DC.NONE

    for dc, nets in DC_NETS.items():
        for net in nets:
            if ip in net:
                return dc

    return DC.NONE
